<?php

namespace MSML\Calendar;

use MSML\Calendar\Commands\CreateCalendarEventCategoryCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class CalendarServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('laravel-calendar')
            ->hasConfigFile('calendar')
            ->hasMigration('create_calendar_events_table');

        if ($this->app->runningInConsole()) {
            $this->commands([
                CreateCalendarEventCategoryCommand::class,
            ]);
        }
    }
}
