<?php

namespace MSML\Calendar\Commands;

use Illuminate\Console\Command;

class CreateCalendarEventCategoryCommand extends Command
{
    protected $signature = 'calendar:create-calendar-event-category';

    protected $description = 'Create a calendar event category';

    public function handle(): int
    {
        $categoryName = $this->ask('What is the name of the category?');
        $hexColor = $this->ask('What is the hex color of the category?');

        $categoryModel = config('calendar.event_category_model');

        $categoryModel::create([
            'name' => $categoryName,
            'color' => $hexColor,
        ]);

        $this->info('Category has been made!');

        return self::SUCCESS;
    }
}
