<?php

namespace MSML\Calendar\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mexitek\PHPColors\Color;

/**
 * @property int $id Primary key
 * @property string $name Name of the category
 * @property string $color Hex color code (without # prefix)
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property-read string $prefixed_color Color with # prefix
 * @property-read string $prefixed_text_color Optimal text color for readability
 * @property-read \Illuminate\Database\Eloquent\Model|null $events Event category
 * @property-read \Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Eloquent\Model[] $events Related calendar events
 *
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory query()
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory whereColor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CalendarEventCategory whereUpdatedAt($value)
 */
class CalendarEventCategory extends Model
{
    protected $guarded = [];

    public function events(): HasMany
    {
        return $this->hasMany(config('calendar.event_model'));
    }

    /**
     * @return Attribute<string, never>
     */
    protected function prefixedColor(): Attribute
    {
        return Attribute::get(
            fn () => "#{$this->color}"
        );
    }

    /**
     * @return Attribute<string, never>
     */
    protected function prefixedTextColor(): Attribute
    {
        return Attribute::get(
            function () {
                $color = new Color($this->prefixed_color);

                return $color->isDark()
                    ? "#{$color->lighten(60)}"
                    : "#{$color->darken(40)}";
            }
        );
    }
}
