<?php

namespace MSML\Calendar\Tests;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Foundation\Testing\LazilyRefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Schema;
use MSML\Calendar\CalendarServiceProvider;
use MSML\Calendar\tests\stubs\User;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    use LazilyRefreshDatabase, WithFaker;

    protected function setUp(): void
    {
        parent::setUp();

        Factory::guessFactoryNamesUsing(
            function (string $modelName) {
                $factoryName = class_basename($modelName).'Factory';

                if (str_contains($modelName, 'tests\\stubs\\') || str_contains($modelName, 'tests/stubs/')) {
                    return 'MSML\\Calendar\\tests\\stubs\\factories\\'.$factoryName;
                }

                return 'MSML\\Calendar\\Database\\Factories\\'.$factoryName;
            }
        );
    }

    protected function getPackageProviders($app): array
    {
        return [
            CalendarServiceProvider::class,
        ];
    }

    public function getEnvironmentSetUp($app): void
    {
        config()->set('database.default', 'testing');
        config()->set('database.connections.testing', [
            'driver' => 'sqlite',
            'database' => ':memory:',
            'prefix' => '',
        ]);

        config()->set('calendar.user_model', User::class);
        config()->set('data.validation_strategy', 'always');

        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });

        $migration = include __DIR__.'/../database/migrations/create_calendar_events_table.php';
        $migration->up();
    }
}
