# Laravel CloudFront Cookies

A Laravel package to integrate CloudFront cookies.

## Features
- Generate signed CloudFront cookies for private distributions
- Supports wildcard resource patterns (single or multiple paths)
- Automatically queues cookies via middleware for authenticated users
- Automatically clears cookies on logout
- Works with custom policies


## Installation

Install the package via composer:

```bash
composer require msml/laravel-cloudfront-cookies
```

Publish the config file with:

```bash
php artisan vendor:publish --tag="cloudfront-cookies-config"
```

Add your CloudFront settings in `.env`:

```bash
CLOUDFRONT_DOMAIN=media.example.com
CLOUDFRONT_KEY_PAIR_ID=YOUR_KEY_PAIR_ID
CLOUDFRONT_PRIVATE_KEY_PATH=cloudfront-private.key
```

Enable the middleware on routes that need access:

```php
Route::middleware('ensure.cloudfront.cookies')->group(function () {
    //
});
```

Prevent Laravel from encrypting the cookies in `bootstrap/app.php`:
```php
$middleware->encryptCookies(except: [
    ...CloudFrontCookies::COOKIES,
]);
```

Configure the allowed resource pattern in config/cloudfront-cookies.php:

```php
'resource' => fn ($request) => 'private/*',
```
