<?php

declare(strict_types=1);

namespace MSML\CloudFrontCookies\Contracts;

use DateTimeInterface;

interface CloudFrontCookies
{
    /**
     * @param  string|array<int, string>  $resources
     * @return array{
     *     'CloudFront-Policy': string,
     *     'CloudFront-Signature': string,
     *     'CloudFront-Key-Pair-Id': string
     * }
     */
    public function make(array|string $resources, DateTimeInterface $expiresAt): array;

    /**
     * @param  array<string,string>  $cookies
     **/
    public function queue(array $cookies): void;

    public function clear(): void;
}
