<?php

namespace MSML\CloudFrontCookies\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use MSML\CloudFrontCookies\CloudFrontCookies;
use Symfony\Component\HttpFoundation\Response;

class EnsureCloudFrontCookies
{
    public function __construct(private readonly CloudFrontCookies $cookies) {}

    public function handle(Request $request, Closure $next): Response
    {
        if (!config('cloudfront-cookies.enabled', true) || !$request->user()) {
            return $next($request);
        }

        $cloudFrontCookiesPresent = collect(CloudFrontCookies::COOKIES)
            ->every(fn ($name) => $request->cookies->has($name));

        if (!$cloudFrontCookiesPresent) {
            $resource = config('cloudfront-cookies.resource');

            if (is_callable($resource)) {
                $resource = $resource($request);
            }

            if ($resource) {
                $signed = $this->cookies->make(
                    $resource,
                    now()->addMinutes((int)config('cloudfront-cookies.cookie.minutes', 60))
                );

                $this->cookies->queue($signed);
            }
        }

        return $next($request);
    }
}
