<?php

namespace MSML\CloudFrontCookies\Listeners;

use Illuminate\Auth\Events\Logout;
use MSML\CloudFrontCookies\Contracts\CloudFrontCookies;

class ClearCloudFrontCookiesOnLogout
{
    public function __construct(
        private readonly CloudFrontCookies $cookies
    ) {}

    public function handle(Logout $event): void
    {
        if (!config('cloudfront-cookies.enabled', true)) {
            return;
        }

        $this->cookies->clear();
    }
}
