<?php

return [
    'enabled' => env('CLOUDFRONT_COOKIES_ENABLED', false),

    'domain' => env('CLOUDFRONT_DOMAIN', 'cdn.example.com'),
    'scheme' => env('CLOUDFRONT_SCHEME', 'https'),

    'key_pair_id'      => env('CLOUDFRONT_KEY_PAIR_ID'),
    'private_key_path' => base_path(env('CLOUDFRONT_PRIVATE_KEY_PATH', '')),

    'cookie' => [
        'domain'    => env('CLOUDFRONT_COOKIE_DOMAIN', null),
        'path'      => '/',
        'secure'    => env('CLOUDFRONT_COOKIE_SECURE', true),
        'http_only' => env('CLOUDFRONT_COOKIE_HTTP_ONLY', true),
        'same_site' => env('CLOUDFRONT_COOKIE_SAMESITE', 'None'),
        'minutes'   => (int)env('CLOUDFRONT_COOKIE_MINUTES', 60),
    ],

    /**
     * Resource pattern to grant access to.
     *
     * A fixed string:
     *   'resource' => 'private/directory/foo/*'
     *
     * Or a callable:
     *   'resource' => fn (Request $request) => "private/{$request->user()->id}/*"
     */
    'resource' => '*',
];
