<?php

namespace MSML\CloudFrontCookies\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use MSML\CloudFrontCookies\CloudFrontCookies;
use Symfony\Component\HttpFoundation\Response;
use MSML\CloudFrontCookies\Contracts\CloudFrontCookies as CloudFrontCookiesContract;

class EnsureCloudFrontCookies
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!config('cloudfront-cookies.enabled', true) || !$request->user()) {
            return $next($request);
        }

        $cookies = app(CloudFrontCookiesContract::class);

        $cloudFrontCookiesPresent = collect(CloudFrontCookies::COOKIES)
            ->every(fn ($name) => $request->cookies->has($name));

        if (!$cloudFrontCookiesPresent) {
            $resource = config('cloudfront-cookies.resource');

            if ($resource instanceof Closure) {
                $resource = $resource($request);
            }

            if ($resource) {
                $signed = $cookies->make(
                    $resource,
                    now()->addMinutes((int)config('cloudfront-cookies.cookie.minutes', 60))
                );

                $cookies->queue($signed);
            }
        }

        return $next($request);
    }
}
