<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use Illuminate\Support\Facades\DB;
use MSML\MediaManager\Models\AssetFolder;
use MSML\MediaManager\Models\MediaNamespace;

final class CreateFolderAction
{
    public function __construct(
        private readonly ResolveFolderFromPathAction $resolveFolderFromPathAction
    ) {}

    public function handle(string $namespaceSlug, string $folderName, string|null $parentPath = null): AssetFolder
    {
        return DB::transaction(function () use ($namespaceSlug, $folderName, $parentPath) {
            $namespace = MediaNamespace::whereSlug($namespaceSlug)->firstOrFail();

            $parentFolder = $this->resolveFolderFromPathAction->handle($namespace, $parentPath);

            return AssetFolder::create([
                'media_namespace_id' => $namespace->id,
                'parent_id'          => $parentFolder?->id,
                'name'               => $folderName,
            ]);
        });
    }
}
