<?php

declare(strict_types=1);

namespace MSML\MediaManager\DataObjects;

use Spatie\LaravelData\Data;
use Illuminate\Support\Collection;
use Spatie\LaravelData\Attributes\MapName;
use Spatie\LaravelData\Mappers\SnakeCaseMapper;
use Spatie\LaravelData\Attributes\DataCollectionOf;

#[MapName(SnakeCaseMapper::class)]
final class MediaNavigationResponse extends Data
{
    /**
     * @param  MediaBreadcrumb[]  $currentPath
     * @param  Collection<int, MediaBrowserItem>  $items
     * @param  array{current_page: int, last_page: int, per_page: int, total: int}|null  $pagination
     */
    public function __construct(
        public readonly array $currentPath,
        #[DataCollectionOf(MediaBrowserItem::class)]
        public readonly Collection $items,
        public readonly array|null $pagination,
        public readonly bool $canGoUp,
    ) {}
}
