<?php

declare(strict_types=1);

namespace MSML\MediaManager;

use MSML\MediaManager\ValueObjects\NamespaceConfiguration;

class MediaManager
{
    /**
     * @var array<string, \Closure(NamespaceConfiguration):NamespaceConfiguration>
     */
    protected array $namespaceRules = [];

    public function registerNamespaceConfigurationFor(string $name, \Closure $callback): void
    {
        $this->namespaceRules[$name] = $callback;
    }

    public function namespaceConfigurationFor(string $name): NamespaceConfiguration|null
    {
        if (!isset($this->namespaceRules[$name])) {
            return null;
        }

        $configurator = NamespaceConfiguration::create($name);

        return $this->namespaceRules[$name]($configurator);
    }
}
