<?php

declare(strict_types=1);

namespace MSML\MediaManager\Rules;

use MSML\MediaManager\Enums\AssetAction;

final class AllowRootFilesRule implements Rule
{
    public function __construct(
        private readonly bool $allowRootFiles
    ) {}

    public function evaluate(RuleContext $context): RuleResult
    {
        return match ($context->action) {
            AssetAction::UPLOAD, AssetAction::MOVE, AssetAction::CREATE_FOLDER, AssetAction::LINK => $this->evaluateRootAccess($context),
            default => RuleResult::skip(__('media-manager::rules.general.not_applicable'))
        };
    }

    private function evaluateRootAccess(RuleContext $context): RuleResult
    {
        if (!$context->inRoot) {
            return RuleResult::skip(
                __('media-manager::rules.allow_root_files.skip_not_root')
            );
        }

        if ($this->allowRootFiles) {
            return RuleResult::pass();
        }

        return RuleResult::fail(
            __('media-manager::rules.allow_root_files.fail')
        );
    }
}
