<?php

declare(strict_types=1);

namespace MSML\MediaManager\DataObjects;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Attributes\MapInputName;

final class MediaNavigation extends Data
{
    public function __construct(
        public readonly string|null $namespaceSlug = null,
        public readonly string|null $folderPath = null,
        public readonly string|null $search = null,
        public readonly int $page = 1,
        #[MapInputName('per_page')]
        public readonly int $perPage = 15,
        #[MapInputName('sort_column')]
        public readonly string|null $sortColumn = null,
        #[MapInputName('sort_direction')]
        public readonly string|null $sortDirection = null,
    ) {}

    public function isRootLevel(): bool
    {
        return $this->namespaceSlug === null;
    }

    public function isNamespaceLevel(): bool
    {
        return $this->namespaceSlug !== null && $this->folderPath === null;
    }

    public function isFolderLevel(): bool
    {
        return $this->namespaceSlug !== null && $this->folderPath !== null;
    }
}
