<?php

declare(strict_types=1);

namespace MSML\MediaManager\DataObjects;

use DateTimeInterface;
use Spatie\LaravelData\Data;
use Illuminate\Support\Number;
use Spatie\LaravelData\Attributes\MapName;
use Spatie\LaravelData\Attributes\Computed;
use Spatie\LaravelData\Mappers\SnakeCaseMapper;
use MSML\MediaManager\Enums\MediaBrowserItemTypeEnum;

#[MapName(SnakeCaseMapper::class)]
final class MediaBrowserItem extends Data
{
    #[Computed]
    public string|null $formattedSize;

    /**
     * @param  array<string, mixed>  $metadata
     * @param  array<string>|string|null  $path
     */
    public function __construct(
        public readonly int $id,
        public readonly string $name,
        public readonly MediaBrowserItemTypeEnum $type,
        public readonly array|string|null $path,
        public readonly int|null $size,
        public readonly DateTimeInterface $createdAt,
        public readonly string|null $thumbUrl,
        public readonly string|null $mimeType = null,
        public readonly array $metadata = [],
    ) {
        $this->formattedSize = $this->formattedSize();
    }

    private function formattedSize(): string|null
    {
        return $this->size ? Number::fileSize($this->size) : null;
    }
}
