<?php

declare(strict_types=1);

namespace MSML\MediaManager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $media_namespace_id
 * @property string $model_type
 * @property \Illuminate\Support\Carbon $created_at
 * @property \Illuminate\Support\Carbon $updated_at
 * @property-read MediaNamespace $namespace
 *
 * @mixin \Eloquent
 */
class MediaNamespaceClaim extends Model
{
    /**
     * @var list<string>
     */
    protected $fillable = [
        'media_namespace_id',
        'model_type',
    ];

    /**
     * @return BelongsTo<MediaNamespace, $this>
     */
    public function namespace(): BelongsTo
    {
        return $this->belongsTo(MediaNamespace::class, 'media_namespace_id');
    }
}
