<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use MSML\MediaManager\Models\AssetFolder;
use MSML\MediaManager\Models\MediaNamespace;
use Illuminate\Database\Eloquent\Relations\HasMany;

final class GetDirectoryListAction
{
    /**
     * @return array<int, array{value: string, label: string, namespace_id: int}>
     */
    public function handle(): array
    {

        /** @var array<int, array{value: string, label: string, namespace_id: int}> */
        $result = MediaNamespace::with(['folders' => fn (HasMany $q) => $q->with('parent')])->get()->flatMap(function (MediaNamespace $namespace) {
            $options = collect([[
                'value'        => $namespace->slug,
                'label'        => $namespace->name,
                'namespace_id' => $namespace->id,
            ]]);

            $folders = $namespace->folders->withRelationshipAutoloading();

            $folderOptions = $folders->map(function (AssetFolder $folder) use ($namespace) {
                $pathSegments = $folder->getPathSegments();

                return [
                    'value'        => $namespace->slug . '/' . implode('/', $pathSegments),
                    'label'        => $namespace->name . '/' . implode('/', $pathSegments),
                    'namespace_id' => $namespace->id,
                ];
            });

            return $options->concat($folderOptions);

        })->toArray();

        return $result;
    }
}
