<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use Illuminate\Support\Collection;
use MSML\MediaManager\Models\Asset;

final class ResolveAssetsAction
{
    /**
     * Resolve mixed asset input to Asset collection.
     *
     * @param  array<int|Asset>  $assets
     * @return Collection<int, Asset>
     */
    public function handle(array $assets): Collection
    {
        $assetIds = [];
        $assetInstances = [];

        foreach ($assets as $asset) {
            if ($asset instanceof Asset) {
                $assetInstances[] = $asset;
            } else {
                $assetIds[] = $asset;
            }
        }

        if (!empty($assetIds)) {
            $foundAssets = Asset::with(['media', 'namespace'])->whereIn('id', $assetIds)->get();
            foreach ($foundAssets as $asset) {
                $assetInstances[] = $asset;
            }
        }

        return collect($assetInstances);
    }
}
