<?php

declare(strict_types=1);

namespace MSML\MediaManager\Rules;

final class RulesEngine
{
    /**
     * @param  Rule[]  $rules
     */
    public function evaluate(array $rules, RuleContext $context): EngineResult
    {
        $results = [];

        foreach ($rules as $rule) {
            try {
                $results[] = $rule->evaluate($context);
            } catch (\Exception $e) {
                $results[] = RuleResult::fail(
                    'Rule error: ' . $e->getMessage()
                );
            }
        }

        return new EngineResult($results);
    }
}
