<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use Illuminate\Support\Facades\DB;
use MSML\MediaManager\Models\Asset;

final class BulkDeleteAssetsAction
{
    public function __construct(
        private readonly DeleteAssetAction $deleteAssetAction,
        private readonly ResolveAssetsAction $resolveAssetsAction
    ) {}

    /**
     * Delete multiple assets in a single transaction.
     *
     * @param  array<int|Asset>  $assets  Array of Asset instances or asset IDs
     * @return int The number of assets successfully deleted
     */
    public function handle(array $assets): int
    {
        if (empty($assets)) {
            return 0;
        }

        return DB::transaction(function () use ($assets) {
            $deletedCount = 0;
            $assetCollection = $this->resolveAssetsAction->handle($assets);

            foreach ($assetCollection as $asset) {
                if ($this->deleteAssetAction->handle($asset)) {
                    $deletedCount++;
                }
            }

            return $deletedCount;
        });
    }
}
