<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use InvalidArgumentException;
use Illuminate\Support\Facades\DB;
use MSML\MediaManager\Models\Asset;

final class EditAssetAction
{
    /**
     * @param  array<string, mixed>|null  $metadata
     *
     * @throws InvalidArgumentException
     */
    public function handle(
        Asset $asset,
        string|null $newName = null,
        array|null $metadata = null
    ): Asset {
        return DB::transaction(function () use ($asset, $newName, $metadata): Asset {
            $updateData = [];

            if ($newName !== null && $newName !== $asset->original_name) {
                $media = $asset->getFirstMediaItem();

                if ($media and $asset->original_name) {
                    $extension = pathinfo($asset->original_name, PATHINFO_EXTENSION);
                    $newFileName = $newName . ($extension ? '.' . $extension : '');

                    $media->update(['file_name' => $newFileName]);

                    $currentMetadata = $asset->metadata ?? [];
                    $updateData['metadata'] = $currentMetadata;
                }
            }

            if ($metadata !== null) {
                $currentMetadata = $updateData['metadata'] ?? $asset->metadata ?? [];
                $updateData['metadata'] = array_merge($currentMetadata, $metadata);
            }

            if (!empty($updateData)) {
                $asset->update($updateData);
                $asset->refresh();
            }

            return $asset;
        });
    }
}
