<?php

declare(strict_types=1);

namespace MSML\MediaManager\Rules;

final class EngineResult
{
    /**
     * @param  RuleResult[]  $results
     */
    public function __construct(private array $results) {}

    public static function success(): self
    {
        return new self([]);
    }

    public function passed(): bool
    {
        foreach ($this->results as $result) {
            if ($result->failed()) {
                return false;
            }
        }

        return true;
    }

    public function failed(): bool
    {
        return !$this->passed();
    }

    /**
     * @return string[]
     */
    public function getErrors(): array
    {
        $errors = [];
        foreach ($this->results as $result) {
            if ($result->failed() && $result->getMessage() !== null) {
                $errors[] = $result->getMessage();
            }
        }

        return $errors;
    }

    public function getFirstError(): string|null
    {
        foreach ($this->results as $result) {
            if ($result->failed()) {
                return $result->getMessage();
            }
        }

        return null;
    }

    /**
     * @return RuleResult[]
     */
    public function getResults(): array
    {
        return $this->results;
    }
}
