<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use Illuminate\Support\Facades\DB;
use MSML\MediaManager\Models\Asset;

final class DeleteAssetAction
{
    public function handle(Asset $asset): bool|null
    {
        return DB::transaction(function () use ($asset) {
            DB::table('assetables')->where('asset_id', $asset->id)->delete();

            $asset->clearMediaCollection();

            return $asset->delete();
        });
    }
}
