<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use InvalidArgumentException;
use MSML\MediaManager\Models\Asset;
use Symfony\Component\HttpFoundation\StreamedResponse;

final class DownloadAssetAction
{
    /**
     * @throws InvalidArgumentException
     */
    public function handle(Asset $asset): StreamedResponse
    {
        $media = $asset->getFirstMediaItem();

        if (!$media) {
            throw new InvalidArgumentException('Asset has no media file');
        }

        return $media->toResponse(request());
    }
}
