<?php

declare(strict_types=1);

namespace MSML\MediaManager\Actions;

use MSML\MediaManager\Models\AssetFolder;
use MSML\MediaManager\Models\MediaNamespace;

final class GetDirectoryListAction
{
    /**
     * @return array<int, array{value: string, label: string, namespace_id: int}>
     */
    public function handle(): array
    {

        /** @var array<int, array{value: string, label: string, namespace_id: int}> */
        $result = MediaNamespace::with('folders')->get()->flatMap(function (MediaNamespace $namespace) {
            $options = collect([[
                'value'        => $namespace->slug,
                'label'        => $namespace->name,
                'namespace_id' => $namespace->id,
            ]]);

            $folderOptions = $namespace->folders->map(function (AssetFolder $folder) use ($namespace) {
                return [
                    'value'        => $namespace->slug . '/' . implode('/', $folder->getPathSegments()),
                    'label'        => $namespace->name . '/' . implode('/', $folder->getPathSegments()),
                    'namespace_id' => $namespace->id,
                ];
            });

            return $options->concat($folderOptions);

        })->toArray();

        return $result;
    }
}
