<?php

declare(strict_types=1);

namespace MSML\MediaManager\Rules;

final class RuleResult
{
    /**
     * @param  array<string, mixed>  $metadata
     */
    public function __construct(
        private readonly bool $passed,
        private readonly string|null $message = null,
        private readonly array $metadata = []
    ) {}

    public static function pass(string|null $message = null): self
    {
        return new self(true, $message);
    }

    /**
     * @param  array<string, mixed>  $metadata
     */
    public static function fail(string $message, array $metadata = []): self
    {
        return new self(false, $message, $metadata);
    }

    public static function skip(string $message): self
    {
        return new self(true, $message);
    }

    public function passed(): bool
    {
        return $this->passed;
    }

    public function failed(): bool
    {
        return !$this->passed;
    }

    public function getMessage(): string|null
    {
        return $this->message;
    }

    /**
     * @return array<string, mixed>
     */
    public function getMetadata(): array
    {
        return $this->metadata;
    }
}
