<?php

declare(strict_types=1);

namespace MSML\MediaManager;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class MediaManagerServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('media-manager')
            ->hasConfigFile()
            ->hasTranslations()
            ->hasMigrations([
                'create_media_namespaces_table',
                'create_media_namespace_claims_table',
                'create_asset_folders_table',
                'create_assets_table',
                'create_assetables_table',
            ]);
    }
}
