<?php

namespace MSML\SocialiteAzureApp;

use Firebase\JWT\JWT;
use SocialiteProviders\Manager\OAuth2\User;
use SocialiteProviders\Manager\OAuth2\AbstractProvider;

class Provider extends AbstractProvider
{
    public const IDENTIFIER = 'AZURE-APP';

    protected $scopeSeparator = ' ';

    protected $scopes = ['openid', 'profile', 'email', 'offline_access'];

    public static function additionalConfigKeys(): array
    {
        return ['tenant', 'endpoint_name'];
    }

    protected function getBaseUrl(): string
    {
        return 'https://login.microsoftonline.com/' . $this->getConfig('tenant');
    }

    protected function getAuthUrl($state): string
    {
        $this->scopes[] = 'api://' . $this->getConfig('client_id') . '/' . $this->getConfig('endpoint_name', 'access');

        return $this->buildAuthUrlFromBase($this->getBaseUrl() . '/oauth2/v2.0/authorize', $state);
    }

    protected function getTokenUrl(): string
    {
        return $this->getBaseUrl() . '/oauth2/v2.0/token';
    }

    protected function getUserByToken($token): array
    {
        return [];
    }

    protected function mapUserToObject(array $user): User
    {
        [$firstName, $lastName] = explode(" ", str_replace('(EXT)', '', $user['name']), 2);

        return (new User())->setRaw($user)->map([
            'id'        => $user['oid'] ?? $user['sub'] ?? null,
            'nickname'  => null,
            'name'      => $user['name'] ?? null,
            'email'     => $user['email'] ?? $user['preferred_username'] ?? null,
            'avatar'    => null,
            'givenName' => $firstName,
            'surname'   => $lastName,
        ]);
    }

    public function user(): User
    {
        $response = $this->getAccessTokenResponse($this->getCode());

        $claims = $this->decodeJwt($response['id_token'] ?? '');

        $user = $this->mapUserToObject($claims);

        return $user->setToken($response['access_token'] ?? null)
            ->setRefreshToken($response['refresh_token'] ?? null)
            ->setExpiresIn($response['expires_in'] ?? null)
            ->setApprovedScopes(explode(' ', $response['scope'] ?? ''));
    }

    protected function decodeJwt(string $jwt): array
    {
        $parts = explode('.', $jwt);

        $payloadJson = JWT::urlsafeB64Decode($parts[1]);
        $payload = JWT::jsonDecode($payloadJson);

        return (array) $payload;
    }
}
