<?php

declare(strict_types=1);

namespace MSML\Surveys\Models;

use Spatie\LaravelData\DataCollection;
use Illuminate\Database\Eloquent\Model;
use MSML\Surveys\Casts\QuestionTypeModelCast;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use MSML\Surveys\DataObjects\SurveyQuestionOptionData;

/**
 * @property int $id
 * @property int $survey_id
 * @property string $order
 * @property \MSML\Surveys\Casts\QuestionTypeModelCast $type
 * @property string $question
 * @property bool $required
 * @property bool $has_conditional_routing
 * @property DataCollection<int, SurveyQuestionOptionData> $options
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \MSML\Surveys\Models\SurveyQuestionResponse|Model> $surveyQuestionResponses
 * @property-read \MSML\Surveys\Models\Survey|Model $survey
 */
class SurveyQuestion extends Model
{
    /**
     * @var list<string>
     */
    protected $guarded = ['id'];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'type'                    => QuestionTypeModelCast::class,
            'required'                => 'bool',
            'has_conditional_routing' => 'bool',
            'options'                 => DataCollection::class . ':' . SurveyQuestionOptionData::class,
        ];
    }

    /**
     * @return BelongsTo<Survey|Model, $this>
     */
    public function survey(): BelongsTo
    {
        return $this->belongsTo(config('surveys.models.survey'));
    }

    /**
     * @return HasMany<SurveyQuestionResponse|Model, $this>
     */
    public function surveyQuestionResponses(): HasMany
    {
        return $this->hasMany(config('surveys.models.survey_question_response'));
    }
}
