<?php

declare(strict_types=1);

namespace MSML\Surveys\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $survey_response_id
 * @property int $survey_question_id
 * @property int|null $skipped_by_question_response_id
 * @property string $answer
 * @property-read SurveyResponse|Model $surveyResponse
 * @property-read SurveyQuestion|Model $surveyQuestion
 * @property-read SurveyQuestionResponse|Model $skippedByQuestionResponse
 */
class SurveyQuestionResponse extends Model
{
    /**
     * @var list<string>
     */
    protected $guarded = ['id'];

    /**
     * @var array<string, string>
     */
    protected $casts = [
        'answer' => 'array',
    ];

    /**
     * @return BelongsTo<SurveyResponse|Model, $this>
     */
    public function surveyResponse(): BelongsTo
    {
        return $this->BelongsTo(config('surveys.models.survey_response'));
    }

    /**
     * @return BelongsTo<SurveyQuestion|Model, $this>
     */
    public function surveyQuestion(): BelongsTo
    {
        return $this->BelongsTo(config('surveys.models.survey_question'));
    }

    /**
     * @return BelongsTo<SurveyQuestionResponse|Model, $this>
     */
    public function skippedByQuestionResponse(): BelongsTo
    {
        return $this->belongsTo(config('surveys.models.survey_question_response'), 'skipped_by_question_response_id');
    }
}
