<?php

declare(strict_types=1);

namespace MSML\Surveys\DataObjects;

use Spatie\LaravelData\Data;
use Illuminate\Support\Collection;
use Spatie\LaravelData\Casts\EnumCast;
use Spatie\LaravelData\Attributes\MapName;
use Spatie\LaravelData\Attributes\WithCast;
use MSML\Surveys\Enums\SurveyQuestionTypeEnum;
use Spatie\LaravelData\Mappers\SnakeCaseMapper;
use Spatie\LaravelData\Attributes\DataCollectionOf;

#[MapName(SnakeCaseMapper::class)]
final class SurveyQuestionData extends Data
{
    public function __construct(
        public readonly int|null $id,
        public readonly string $question,
        public readonly int $order,
        public readonly bool $hasConditionalRouting,
        #[WithCast(EnumCast::class)]
        public readonly SurveyQuestionTypeEnum $type,
        public readonly bool $required,
        #[DataCollectionOf(SurveyQuestionOptionData::class)]
        public readonly Collection|null $options,
    ) {
        //
    }

}
