<?php

declare(strict_types=1);

namespace MSML\Surveys\DataObjects;

use Carbon\Carbon;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Attributes\MapName;
use Spatie\LaravelData\Mappers\SnakeCaseMapper;

#[MapName(SnakeCaseMapper::class)]
final class SurveyQuestionOptionData extends Data
{
    public function __construct(
        public readonly int|Optional $index,
        public readonly Optional|string|null $answer,
        public readonly Carbon|Optional $conditionalRoutingBeforeDate,
        public readonly Carbon|Optional $conditionalRoutingAfterDate,
        public readonly Optional|SurveyConditionalRoutingData $conditionalRouting,
    ) {
        //
    }
}
