<?php

namespace MSML\Surveys\Enums;

enum SurveyQuestionTypeEnum: string
{
    case Bool = 'bool';
    case Date = 'date';
    case Image = 'image';
    case Input = 'input';
    case Multi = 'multi';
    case Numeric = 'numeric';
    case Single = 'single';
    case Comment = 'comment';

    public function name(): string
    {
        return match ($this) {
            self::Bool    => 'Yes/No',
            self::Date    => 'Date',
            self::Image   => 'Image',
            self::Input   => 'Short input',
            self::Multi   => 'Multiselect',
            self::Numeric => 'Numeric',
            self::Single  => 'Single choice',
            self::Comment => 'Comment',
        };
    }

    public function requiresOptions(): bool
    {
        return match ($this) {
            self::Multi  => true,
            self::Single => true,
            default      => false,
        };
    }

    public function defaultOptions(): array|null
    {
        return match ($this) {
            self::Multi  => [['index' => 0, 'answer' => '']],
            self::Single => [['index' => 0, 'answer' => '']],
            self::Bool   => [['index' => 0, 'answer' => 'Yes'], ['index' => 1, 'answer' => 'No']],
            self::Date   => [
                ['index' => 0, 'conditional_routing_before_date' => null],
                ['index' => 1, 'conditional_routing_after_date' => null],
            ],
            default => null,
        };
    }
}
