<?php

declare(strict_types=1);

namespace MSML\Surveys\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait HasSurveys
{
    /**
     * @return HasMany<\MSML\Surveys\Models\Survey|Model>
     */
    public function surveys(): HasMany
    {
        return $this->hasMany(config('surveys.models.survey'));
    }

    /**
     * @return HasMany<\MSML\Surveys\Models\SurveyResponse|Model>
     */
    public function surveyResponses(): HasMany
    {
        return $this->HasMany(config('surveys.models.survey_response'));
    }
}
