<?php

declare(strict_types=1);

namespace MSML\Surveys\Casts;

use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Support\DataProperty;
use Spatie\LaravelData\Support\Creation\CreationContext;

class QuestionTypeCast implements Cast
{
    public function cast(DataProperty $property, mixed $value, array $properties, CreationContext $context): mixed
    {
        if ($value instanceof \BackedEnum) {
            return $value;
        }

        $enumClass = config('surveys.question_type_enum');

        return $enumClass::from($value);
    }
}
