<?php

declare(strict_types=1);

namespace MSML\Surveys\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class SurveyTypeModelCast implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): \BackedEnum|null
    {
        if ($value === null) {
            return null;
        }

        $enumClass = config('surveys.survey_type_enum');

        return $enumClass::from($value);
    }

    public function set($model, string $key, $value, array $attributes): string|null
    {
        if ($value instanceof \BackedEnum) {
            return $value->value;
        }

        return $value;
    }
}
