<?php

declare(strict_types=1);

namespace MSML\Surveys\DataObjects;

use BackedEnum;
use Spatie\LaravelData\Data;
use Illuminate\Support\Collection;
use MSML\Surveys\Casts\QuestionTypeCast;
use Spatie\LaravelData\Attributes\MapName;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Mappers\SnakeCaseMapper;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\WithoutValidation;

#[MapName(SnakeCaseMapper::class)]
final class SurveyQuestionData extends Data
{
    public function __construct(
        public readonly int|null $id,
        public readonly string $question,
        public readonly int $order,
        public readonly bool $hasConditionalRouting,
        #[WithCast(QuestionTypeCast::class)]
        #[WithoutValidation]
        public readonly BackedEnum $type,
        public readonly bool $required,
        #[DataCollectionOf(SurveyQuestionOptionData::class)]
        public readonly Collection|null $options,
    ) {
        //
    }
}
