# Laravel Surveys

A powerful and flexible Laravel package for creating dynamic, model-agnostic surveys with advanced question types, conditional routing, and comprehensive response analytics.

## Features

-   **Multiple Question Types** - Support for numeric, boolean, image, date, single choice, multiple choice, short input, and comment questions
-   **Analytics** - Built-in result insights and response tracking
-   **Conditional Routing** - Create dynamic surveys with conditional routing
-   **Publishing** - Schedule surveys with publish and end dates
-   **Response Controls** - Limit max responses and enforce single submission per user

## Requirements

-   PHP 8.3 or higher
-   Laravel 12.0 or higher

## Installation

Install via Composer:

```bash
composer require msml/laravel-surveys
```

Publish and run the migrations:

```bash
php artisan vendor:publish --tag="app-surveys-migrations"
php artisan migrate
```

Optionally, publish the config file:

```bash
php artisan vendor:publish --tag="surveys-config"
```

## Basic Usage

### Sync survey questions

Create, edit and delete survey questions using this action.

```php
$action = new SyncSurveyQuestionsAction;


$data = SyncSurveyQuestionActionData::from([
        'questions' => [
            [
                'id'                      => 1,
                'question'                => 'This is a test question?',
                'order'                   => 1,
                'has_conditional_routing' => false,
                'type'                    => 'single',
                'required'                => true,
                'options'                 => null,
            ],
            [
                'id'                      => 2,
                'question'                => 'This is a second test question?',
                'order'                   => 2,
                'has_conditional_routing' => false,
                'type'                    => 'single',
                'required'                => true,
                'options'                 => null,
            ],
        ],
    ]);

$action->handle($survey, $data);
```

### Publishing & Unpublishing Surveys

Control when your surveys are available to respondents by managing their publication status.

```php
$survey = new Survey([
    'title' => 'test',
    'user_id' => auth()->id(),
]);

// Publish immediately (sets published_at to now)
$survey->publish();

// Unpublish (sets published_at to null)
$survey->publish(false);
```

### Duplicating Surveys

Duplicate a survey using the DuplicateSurveyAction.

```php
$action = new DuplicateSurveyAction();

$duplicatedSurvey = $action->handle($survey, [
    'title' => 'Copy of ' . $survey->title,
]);
```

## Advanced Usage

### Conditional Routing

Create dynamic surveys that skip to different questions based on user responses.

```php
$question = $survey->surveyQuestions()->create([
    'question' => 'Are you a returning customer?',
    'type' => 'bool',
    'required' => true,
    'has_conditional_routing' => true,
    'options' => [
      'index' => 1,
        'answer' => 'testanswer1',
        'conditional_routing' => [
        'value' => '6',
        'label' => 'Go to question 6',
        'order' => 6,
      ]
    ],
]);
```

### Model Configuration

The package allows you to use your own model implementations. Configure the models in `config/surveys.php`:

```php
return [
    'models' => [
        'survey' => \App\Models\Survey::class,
        'survey_question' => \App\Models\SurveyQuestion::class,
        'survey_question_response' => \App\Models\SurveyQuestionResponse::class,
        'survey_response' => \App\Models\SurveyResponse::class,
    ],
];
```

## Testing

```bash
composer test
```

## Credits

-   [MSML](https://github.com/msmlbv)
-   [All Contributors](../../contributors)

## License

The MIT License (MIT). See [LICENSE.md](LICENSE.md) for details.
