<?php

return [
    'models' => [

        /*
         * When using the "HasSurveys" trait from this package, we need to know which
         * Eloquent model should be used to retrieve your surveys. Of course, it
         * is often just the "Survey" model but you may use whatever you like.
         *
         * The model you want to use as a Survey model needs to extend the
         * `MSML\Surveys\Models\Survey` base model.
         */

        'survey' => MSML\Surveys\Models\Survey::class,

        /*
         * The SurveyQuestion model handles all question-related operations within
         * your surveys. You can extend this model to add custom functionality
         * such as additional question types or validation rules.
         *
         * The model you want to use as a SurveyQuestion model needs to extend the
         * `MSML\Surveys\Models\SurveyQuestion` base model.
         */

        'survey_question' => MSML\Surveys\Models\SurveyQuestion::class,

        /*
         * The SurveyQuestionResponse model stores individual responses to each
         * question in a survey. You may extend this model to add custom
         * response processing or validation logic.
         *
         * The model you want to use as a SurveyQuestionResponse model needs to extend the
         * `MSML\Surveys\Models\SurveyQuestionResponse` base model.
         */

        'survey_question_response' => MSML\Surveys\Models\SurveyQuestionResponse::class,

        /*
         * The SurveyResponse model represents a complete survey submission from
         * a respondent. You can extend this model to add custom functionality
         * such as response scoring or completion tracking.
         *
         * The model you want to use as a SurveyResponse model needs to extend the
         * `MSML\Surveys\Models\SurveyResponse` base model.
         */

        'survey_response' => MSML\Surveys\Models\SurveyResponse::class,
    ],
];
