<?php

declare(strict_types=1);

namespace MSML\Surveys\Actions;

use MSML\Surveys\Models\Survey;
use Illuminate\Support\Facades\DB;
use MSML\Surveys\DataObjects\SurveyDuplicationData;

final class DuplicateSurveyAction
{
    public function handle(Survey $survey, array|SurveyDuplicationData $data, int $userId): Survey
    {
        $data = $data instanceof SurveyDuplicationData ? $data : SurveyDuplicationData::from($data);

        return DB::transaction(function () use ($survey, $data, $userId) {
            $newSurvey = $survey->replicate(['published_at', 'ended_at']);
            $newSurvey->user()->associate($userId);
            $newSurvey->title = $data->title;
            $newSurvey->save();

            $survey->surveyQuestions->each(function ($question) use ($newSurvey) {
                /** @var \MSML\Surveys\Models\SurveyQuestion $question */
                $newQuestion = $question->replicate();
                $newQuestion->survey_id = $newSurvey->id;
                $newQuestion->save();
            });

            return $newSurvey;
        });
    }
}
