<?php

declare(strict_types=1);

namespace MSML\Surveys\Actions;

use MSML\Surveys\Models\Survey;
use MSML\Surveys\DataObjects\SurveyQuestionData;
use MSML\Surveys\DataObjects\SurveyQuestionSyncData;

final class SyncSurveyQuestionsAction
{
    public function handle(Survey $survey, array|SurveyQuestionSyncData $data): void
    {
        $data = $data instanceof SurveyQuestionSyncData ? $data : SurveyQuestionSyncData::from($data);

        $submittedIds = $data->questions->pluck('id')->filter()->toArray();

        if (!empty($submittedIds)) {
            $survey->surveyQuestions()->whereNotIn('id', $submittedIds)->delete();
        } else {
            $survey->surveyQuestions()->delete();
        }

        $data->questions->each(function (SurveyQuestionData $surveyQuestionData) use ($survey) {
            $survey->surveyQuestions()->updateOrCreate(
                ['id' => $surveyQuestionData->id],
                $surveyQuestionData->toArray(),
            );
        });
    }
}
