<?php

declare(strict_types=1);

namespace MSML\Surveys\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $user_id
 * @property int $survey_question_id
 * @property-read Model $user
 * @property-read \Illuminate\Database\Eloquent\Collection<int, SurveyQuestionResponse|Model> $surveyQuestionResponses
 */
class SurveyResponse extends Model
{
    /**
     * @var list<string>
     */
    protected $guarded = ['id'];

    /**
     * @return BelongsTo<Survey, $this>
     */
    public function survey(): BelongsTo
    {
        return $this->belongsTo(Survey::class);
    }

    /**
     * @return BelongsTo<Model, $this>
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }

    /**
     * @return HasMany<SurveyQuestionResponse|Model, $this>
     */
    public function surveyQuestionResponses(): HasMany
    {
        return $this->hasMany(config('surveys.models.survey_question_response'));
    }
}
