# Laravel Tables

A Laravel package to configure tables from a single source of truth.

## Features

* Define and control columns
* Define and control filtering
* Opt in export flow basis using PHP Generators
* Create new tables through the `make:table` command
* A built-in action for retrieving paginated table data from the request.

## Installation

Install via Composer:

```bash
composer require msml/laravel-tables
```

Publish the config:

```bash
php artisan vendor:publish --tag="tables-config"
```

Published config:

```php
return [
    /*
     * The path where the tables classes will be created.
     */
    'table_class_path' => app_path('Tables'),
];
```

## Usage

### Creating a new table

You can create a new table by running the command:

```bash
php artisan make:table UsersTable
```

This will create a base table file in the configured namespace.

### Configuring a table

The base table contains the following abstract methods that should be implemented on the table:

- query (The method used for retrieving the data.)
- resource (The method used for returning the retrieved data in the wanted format.)
- defineColumns (The method in which the columns can to be defined.)
    - Internally, the columns method is being called which is a proxy for the defineColumns method. This way, the columns can be intercepted and if needed changed according to business logic.

By default, all tables will be paginated by a page size of 15. If you want to change the default, or decide this through business logic, the `getPageSize` method can be implemented.

The table will be named, by default this is a snake case version of the table name. If you want to overwrite this, the `name()` method can be implemented accordingly.

### Retrieving table data

The package includes an action that can retrieve the table data from a request. 
For example, you can define a controller like this and call the action for the table.
The table can be retrieved by using `{table}` in your routes file for automatic injection of the correct table using it's name.

```php
...
use Illuminate\Http\Requesst;
use MSML\Tables\Actions\RetrieveTableDataAction;
use Illuminate\Http\Resources\Json\ResourceCollection;

public function index(Request $request, Table $table, RetrieveTableDataAction $action): ResourceCollection 
{
    return $action->handle(table: $table, request: $request, limit: 15);
}
```

## Testing

```bash
composer test
```

## Credits

* [MSML](https://github.com/msmlbv)
* All contributors

## License

The MIT License (MIT). See [LICENSE.md](LICENSE.md) for details.
