<?php

declare(strict_types=1);

namespace MSML\Tables\Actions;

use MSML\Tables\Table;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

final class RetrieveTableDataAction
{
    public function handle(Table $table, Request $request, int $limit): JsonResource
    {
        $paginatedData = $table->query($request)->orderByDesc('id')->paginate($limit);

        return JsonResource::collection($paginatedData->through($table->resource(...)));
    }
}
