# Changelog

All notable changes to `laravel-tables` will be documented in this file.

## v0.2.0

### Fixed
- Fixed copy-paste bug in `ColumnSchema::buildAllowedSort()` where `customFilter` was checked instead of `customSort`, preventing custom sort closures from working correctly

### Changed
- **Breaking:** Export customization now uses interfaces instead of `method_exists()` checks. Tables using `transformExportValue()` must implement `TransformsExportValues`, and tables using `customExportableColumns()` must implement `HasCustomExportColumns`
- Narrowed `customFilter` type from `mixed` to `Closure|Filter|null` on `ColumnSchema` and `ColumnBuilder`
- Narrowed `customSort` type from `mixed` to `Closure|Sort|null` on `ColumnSchema` and `ColumnBuilder`
- `TablesServiceProvider` now uses `tables.table_class_namespace` config for class resolution instead of deriving the namespace from the filesystem path

### Added
- `TransformsExportValues` interface for custom export value transformation
- `HasCustomExportColumns` interface for dynamic export columns
- `Table::getExportChunkSize()` method to allow overriding the default export chunk size (2500) per table
- Tests for `MantineReactTableMapper`
- Architecture test for contracts
- Regression tests for custom sort handling
