<?php

declare(strict_types=1);

namespace MSML\Tables\Actions;

use Generator;
use MSML\Tables\Table;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use MSML\Tables\Contracts\HasCustomExportColumns;
use MSML\Tables\Contracts\TransformsExportValues;

final class ExportTableDataAction
{
    public function handle(Table $table, Request $request, Collection $columns): Generator
    {
        foreach ($table->query($request)->orderByDesc('id')->lazy($table->getExportChunkSize()) as $item) {
            $row = [];

            foreach ($table->getSchema()->getColumns() as $column) {
                if (!$columns->contains('accessorKey', $column->key)) {
                    continue;
                }

                $row[$column->header] = $table instanceof TransformsExportValues
                    ? $table->transformExportValue($column, $item)
                    : $column->transformExportValue($item);
            }

            if ($table instanceof HasCustomExportColumns) {
                $row = array_merge($row, $table->customExportableColumns($item));
            }

            yield $row;
        }
    }
}
