<?php

declare(strict_types=1);

namespace MSML\Tables\Schema;

use Closure;

final readonly class ComputedField
{
    public function __construct(
        public string $key,
        public Closure|null $transformer = null,
        public bool $exportable = false,
    ) {}

    public function transformValue(mixed $item): mixed
    {
        if ($this->transformer !== null) {
            return ($this->transformer)($item);
        }

        return data_get($item, $this->key);
    }
}
