<?php

declare(strict_types=1);

namespace MSML\Tables\Sorting;

use Spatie\QueryBuilder\Sorts\Sort;
use Illuminate\Database\Eloquent\Builder;

final class ScopeSort implements Sort
{
    public function __construct(
        private readonly string $scope,
    ) {}

    public function __invoke(Builder $query, bool $descending, string $property): Builder
    {
        $direction = $descending ? 'desc' : 'asc';

        return $query->{$this->scope}($direction);
    }
}
