<?php

declare(strict_types=1);

namespace MSML\Tables\Interfaces;

use Generator;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Database\Eloquent\Builder;

interface Exportable
{
    public function withExport(Builder $query): Builder;

    public function formatExportableColumn(mixed $item, string $formatTo, string $accessorKey): mixed;

    /**
     * @return array<string, mixed>
     */
    public function customExportableColumnParser(): array;

    /**
     * @return array<string, mixed>
     */
    public function customExportableColumns(mixed $item): array;

    public function generator(Request $request, Collection $columns): Generator;
}
